//{ Driver Code Starts
//Initial Template for C++

#include <bits/stdc++.h>
using namespace std;

struct Node
{
    int data;
    struct Node *left;
    struct Node *right;

    Node(int val) {
        data = val;
        left = right = NULL;
    }
};

// Function to Build Tree
Node* buildTree(string str)
{
    // Corner Case
    if (str.length() == 0 || str[0] == 'N')
        return NULL;

    // Creating vector of strings from input
    // string after spliting by space
    vector<string> ip;

    istringstream iss(str);
    for (string str; iss >> str; )
        ip.push_back(str);

    // Create the root of the tree
    Node *root = new Node(stoi(ip[0]));

    // Push the root to the queue
    queue<Node*> queue;
    queue.push(root);

    // Starting from the second element
    int i = 1;
    while (!queue.empty() && i < ip.size()) {

        // Get and remove the front of the queue
        Node* currNode = queue.front();
        queue.pop();

        // Get the current node's value from the string
        string currVal = ip[i];

        // If the left child is not null
        if (currVal != "N") {

            // Create the left child for the current Node
            currNode->left = new Node(stoi(currVal));

            // Push it to the queue
            queue.push(currNode->left);
        }

        // For the right child
        i++;
        if (i >= ip.size())
            break;
        currVal = ip[i];

        // If the right child is not null
        if (currVal != "N") {

            // Create the right child for the current node
            currNode->right = new Node(stoi(currVal));

            // Push it to the queue
            queue.push(currNode->right);
        }
        i++;
    }

    return root;
}


// } Driver Code Ends
//User function Template for C++

/*Structure of the Node of the BST is as
struct Node
{
    int data;
    struct Node *left;
    struct Node *right;

    Node(int val) {
        data = val;
        left = right = NULL;
    }
};
*/

class Solution
{
public:
    void inorder(Node* node,vector<int>& v){
        if(!node) return;
        inorder(node->left,v);
        v.push_back(node->data);
        inorder(node->right,v);
    }
    vector<int>final;
    void merge(vector<int>& v1,vector<int>& v2){
        int i=0,j=0;
        
        while(i<v1.size()&&j<v2.size()){
            if(v1[i]<=v2[j]){
                final.push_back(v1[i]);
                i++;
            }
            else{
                final.push_back(v2[j]);
                j++;
            }
        }
        while(i<v1.size()){
            final.push_back(v1[i]);
            i++;
        }
        while(j<v2.size()){
            final.push_back(v2[j]);
            j++;           
        }
    }

    int countPairs(Node* root1, Node* root2, int x)
    {  
        vector<int>v1;
        vector<int>v2;
        inorder(root1,v1);
        inorder(root2,v2);
        // merge(v1,v2);
        // int i=0,j=final.size()-1;
        int count=0;
        // while(i<j){
        //     int sum=final[i]+final[j];
        //     if(sum>x) j--;
        //     else if(sum<x) i++;
        //     else {
        //         count++;
        //         i++,j--;
        //     }
        // }
        unordered_map<int,int>mp;
        for(int i=0;i<v2.size();i++){
            mp[v2[i]]++;
        }
        for(int i=0;i<v1.size();i++){
            int curr=x-v1[i];
            if(mp[curr]>0){
                count++;
                mp[curr]--;
            }
        }
        return count;
    }
};


//{ Driver Code Starts.

int main()
{
    int t;
    cin >> t;
    cin.ignore();
    while (t--)
    {
        string tree1, tree2;
        getline(cin, tree1);
        getline(cin, tree2);
        Node* root1 = buildTree(tree1);
        Node* root2 = buildTree(tree2);
        int x;
        cin >> x;
        cin.ignore();
        Solution ob;
        cout << ob.countPairs(root1, root2, x) << "\n";
    }
    return 0;
}

// } Driver Code Ends